package com.elitesland.sale.dto.query;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Danny.Wang
 * @title SalesmanQueryDTO
 * @Date2023/3/2 9:54
 */
@Data
public class SalesmanAPPQueryDTO implements Serializable {

    private static final long serialVersionUID = -6531278671345822763L;

    /**
     * 业务员编码
     */
    @ApiModelProperty("业务员编码")
    private String salesmanCode;

    /**
     * 第一次查询,第一次调用赋值为1，只查询自己的信息
     */
    @ApiModelProperty("第一次查询")
    private Integer one;

    /**
     * 是否级联查询下级所有下属,默认为false
     */
    @ApiModelProperty("是否级联查询下级所有下属，默认为false")
    private Boolean cascade = false;
}
