package com.elitesland.sale.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Danny.Wang
 * @title SalesmanLevelInfoDTO
 * @Date2023/3/7 16:15
 */
@Data
@ApiModel("业务员所有上级基本信息")
public class SalesmanLevelInfoDTO implements Serializable{

    @ApiModelProperty("业务员路径")
    private List<path> Salesman_path;

    @ApiModelProperty("业务员路径编号")
    private String salesmanPathCode;

    @ApiModelProperty("id")
    private Long id;

    /**
     *业务员编号
     */
    @ApiModelProperty("业务员编号")
    private String salesmanNo;

    @ApiModelProperty("业务员Id")
    private Long salesmanId;

    /**
     *业务员名称
     */
    @ApiModelProperty("业务员名称")
    private String salesmanName;

    /**
     *区域经理编号
     */
    @ApiModelProperty("区域经理编号")
    private String remanageNo;

    @ApiModelProperty("区域经理id")
    private Long remanageId;
    /**
     *区域经理名称
     */
    @ApiModelProperty("区域经理名称")
    private String remanagerName;

    /**
     *省区经理编号
     */
    @ApiModelProperty("省区经理编号")
    private String prmanagerNo;

    @ApiModelProperty("省区经理Id")
    private Long prmanagerId;

    /**
     *省区经理名称
     */
    @ApiModelProperty("省区经理名称")
    private String prmanagerName;

    /**
     *总监编号
     */
    @ApiModelProperty("总监编号")
    private String chiefNo;

    @ApiModelProperty("总监id")
    private Long chiefId;

    /**
     *总监名称
     */
    @ApiModelProperty("总监名称")
    private String chiefName;

    @Data
    public class path implements Serializable {
        private String code;
        private String type;
        private Integer level;
        private String name;
    }

}
