package com.elitesland.sale.api.vo.resp.taskinfo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-5-19
 * @desc : 销售业绩统计-门店
 */
@Data
@ApiModel(description = "销售业绩统计-门店")
public class SaleStatisticsStoreRespVO extends BaseModelVO {


    /**
     * 区域
     */
    @ApiModelProperty("区域")
    @SysCode(sys = "yst-supp",mod = "REGION")
    private String region;
    private String regionName;

    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    private String storeCode;

    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    private String storeName;

    /**
     * 经销商编码
     */
    @ApiModelProperty("经销商编码")
    private String dealerCode;

    /**
     * 经销商客户号
     */
    @ApiModelProperty("经销商客户号")
    private String dealerSerialNo;

    /**
     * 经销商名称
     */
    @ApiModelProperty("经销商名称")
    private String dealerName;

    /**
     * 类型
     */
    @ApiModelProperty("类型")
    @SysCode(sys = "yst-sale",mod = "STATISTICS_TYPE")
    private String type;
    private String typeName;

    /**
     *业务员名称
     */
    @ApiModelProperty(value = "业务员名称")
    private String agentEmpName;

    /**
     *上级-1
     */
    @ApiModelProperty("上级1")
    private String levelOne;

    /**
     *上级2
     */
    @ApiModelProperty("上级2")
    private String levelTwo;

    /**
     *上级3
     */
    @ApiModelProperty("上级3")
    private String levelThree;

    /**
     *上级4
     */
    @ApiModelProperty("上级4")
    private String levelFour;

    /**
     *上级5
     */
    @ApiModelProperty("上级5")
    private String levelFive;

    /**
     * 车型
     */
    @ApiModelProperty("车型")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE5")
    private String vehicleType;
    private String vehicleTypeName;

    /**
     * 整车类型
     */
    @ApiModelProperty("整车类型")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE3")
    private String itemType3;
    private String itemType3Name;

    /**
     * 统计时间
     */
    @ApiModelProperty("统计月份")
    private String docMonth;


    /**
     * 业务员关系路径
     */
    @ApiModelProperty("业务员关系路径")
    private String salesmanPath;

    /**
     * 出货量
     */
    @ApiModelProperty("出货量")
    private BigDecimal shipQty;

    @ApiModelProperty("汇总出货量")
    private BigDecimal shipTotalQty;
    /**
     * 统计时间
     */
    @ApiModelProperty("统计时间")
    private LocalDateTime docTime;

    /**
     * 附表
     */
    @ApiModelProperty("明细附表")
    private List<SaleStatisticsStoreDtlRespVO> dtlRespVOS;

}