package com.elitesland.sale.api.service;

import com.elitesland.sale.api.vo.param.pri.RmiSalSoDParam;
import com.elitesland.sale.api.vo.param.sal.SalInvApplyCheckParam;
import com.elitesland.sale.api.vo.param.sal.SalInvApplyPageParam;
import com.elitesland.sale.api.vo.param.sal.SalInvApplySaveParam;
import com.elitesland.sale.api.vo.resp.sal.RmiSalSoDVO;
import com.elitesland.sale.api.vo.resp.sal.SalInvApplyRespVO;
import com.elitesland.sale.api.vo.resp.sal.SalInvSerialVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * @author JinXK
 * @date 2021/6/2 13:59
 */
public interface SalInvApplyService {

    /**
     * 销售开票申请分页查询
     */
    PagingVO<SalInvApplyRespVO> query(SalInvApplyPageParam pagingParamVO);

    /**
     * 销售开票申请详情查询
     */
    SalInvApplyRespVO getById(Long id);

    /**
     * 销售开票申请保存或提交
     */
    ApiResult<Object> saveOrSubmitApply(SalInvApplySaveParam param, String operation);

    /**
     * 销售订单查询
     */
    PagingVO<RmiSalSoDVO> selectSo(RmiSalSoDParam pagingParamVO);

    /**
     * 销售开票批量删除
     */
    ApiResult<Object> batchDelete(List<Long> ids);

    /**
     * 批准
     */
    ApiResult<Object> check(SalInvApplyCheckParam param);

    void putSod(List<RmiSalSoDVO> param);

    void approveSod(Long id);

    /**
     * 查询允许红冲发票
     */
    List<SalInvSerialVO> getByFlow(Long id);
}
