package com.elitesland.sale.api.service.shop;

import com.elitesland.sale.api.dto.BipInvItemDTO;
import com.elitesland.sale.api.vo.param.shop.BipOrderDParmVO;
import com.elitesland.sale.api.vo.resp.shop.BipOrderDRespVO;
import com.elitesland.sale.api.vo.save.shop.BipOrderDSaveVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.time.LocalDateTime;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/20/9:53
 * @Description:
 */
public interface BipOrderDService {


    PagingVO<BipOrderDRespVO> findPageOrderD(BipOrderDParmVO bipOrderParmDVO);


    List<BipOrderDRespVO> findOrderD(BipOrderDParmVO bipOrderParmDVO);


    List<BipOrderDRespVO> findOrderById(List<Long> ids);

    List<BipOrderDRespVO> fingOrderDByorderId(Long orderId);


    void updateOrder(List<BipOrderDSaveVO> bipOrderDos);

    void updateOrderDStatus(List<BipOrderDSaveVO> bipOrderDSaveVOS) ;

    void deleteOrderDByIds(List<Long> ids);

    void deleteOrderDById(Long id);


    void deleteOrderD(List<BipOrderDSaveVO> bipOrderDSaveVOS);

    /**
     * @param orderId 订单id
     * @return 根据订单号得到商品code和商品数量--用于发票
     */
    List<BipInvItemDTO> queryItemByOrderId(Long orderId);

    /**
     * 统计商品销量
     *
     * @param itemId 商品ID
     * @return 销量
     */
    ApiResult<Long> countItemSaleNum(Long itemId, LocalDateTime start, LocalDateTime end);
}
