package com.elitesland.sale.dto.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 门店账户保存Rpc参数
 */
@ApiModel("门店账户保存Rpc参数")
@Data
public class StoreAccountSaveRpcParam implements Serializable {

    private static final long serialVersionUID = -8324085647433086224L;
    @ApiModelProperty("门店编号")
    @NotBlank
    private String storeCode;

    @ApiModelProperty("门店联系电话")
    @NotBlank
    private String storeContPhone;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty(value = "是否启用")
    private Boolean enable;
}
