package com.elitesland.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/20
 */
@Data
@ApiModel(description = "商品图文")
public class BipItemPicContentSaveVO implements Serializable {
    private static final long serialVersionUID = -3638622907345446591L;

    @ApiModelProperty(value = "文件的唯一标识", position = 1)
    @NotBlank(message = "图片的标识为空")
    private String fileCode;

    @ApiModelProperty(value = "文件大小", position = 2)
    private Long fileSize;

    @ApiModelProperty(value = "文件名称", position = 3)
    private String fileName;

    @ApiModelProperty(value = "文件的mime-type", position = 4)
    private String mimeType;

    @ApiModelProperty(value = "图片的可访问链接", position = 5)
    private String url;
}
