package com.elitesland.sale.api.vo.param.shop;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/17/11:11
 * @Description:
 */
@Data
public class BipOrderParmVO extends AbstractOrderQueryParam implements Serializable {


    private static final long serialVersionUID = 8388823950023772824L;

    @ApiModelProperty("订单ID")
    private Long id;

    @ApiModelProperty("订单单号")
    private String docNo;

    @ApiModelProperty("退货单单号")
    private String backDocNo;


    @ApiModelProperty("下单人id")
    private Long custAccountId;

    @ApiModelProperty("下单人id")
    private Long custId;

    @ApiModelProperty("下单客户编码")
    private String custCode;

    @ApiModelProperty("下单客户编码")
    private String custCode2;


    @ApiModelProperty("下单客户姓名")
    private String custName;


    @ApiModelProperty("应付金额")
    private BigDecimal payAmt;
    @ApiModelProperty("已付金额")
    private BigDecimal payDoneAmt;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmt;


    @ApiModelProperty("商品合计金额")
    private BigDecimal itemAmt;

    @ApiModelProperty("运费金额")
    private BigDecimal fareAmt;

    @ApiModelProperty("运费收费方式")
    private Boolean freeFare;

    @ApiModelProperty("运费最终金额")
    private BigDecimal fareFinalAmt;

    @ApiModelProperty("优惠券金额")
    private BigDecimal couponAmt;

    @ApiModelProperty("折扣金额")
    private BigDecimal discountAmt;

    @ApiModelProperty("积分抵扣金额")
    private BigDecimal scoreAmt;


    @ApiModelProperty("下单时间")
    private LocalDateTime orderTime;

    @ApiModelProperty("支付方式code")
    private String payMethod;

    @ApiModelProperty("支付方式名称")
    private String payMethodName;

    @ApiModelProperty("订单状态")
    private String status;

    @ApiModelProperty("支付状态")
    private String payStatus;

    @ApiModelProperty("支付时间")
    private LocalDateTime payTime;


    @ApiModelProperty("支付记录id")
    private String payRecordId;

    @ApiModelProperty("是否开票")
    private Boolean invoice;

    @ApiModelProperty("发票id")
    private Long invoiceId;

    @ApiModelProperty("发货id")
    private Long deliveId;

    @ApiModelProperty("发货时间")
    private LocalDateTime deliveTime;


    @ApiModelProperty("订单完成时间")
    private LocalDateTime finishTime;

    @ApiModelProperty("是否评价 0 未评价 1 评价")
    private Boolean isEval;

    @ApiModelProperty("订单评价时间")
    private LocalDateTime evalTime;

    @ApiModelProperty("发货状态")
    private String deliveStatus;

    @ApiModelProperty("要求发货日期")
    private LocalDateTime demandTime;

    @ApiModelProperty("签收日期")
    private LocalDateTime signTime;


    @ApiModelProperty("业务员员工id")
    private Long agentEmpId;

    @ApiModelProperty("业务员员工名字")
    private String agentName;

    @ApiModelProperty("业务员编码")
    private String agentCode;


    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("组织id")
    private Long buId;

    @ApiModelProperty("组织编码")
    private String buCode;

    @ApiModelProperty("组织名称")
    private String buName;


    @ApiModelProperty("寄货人姓名")
    private String shipperName;

    @ApiModelProperty("寄货人电话")
    private String shipperTel;

    @ApiModelProperty("收货人姓名")
    private String receiverName;

    @ApiModelProperty("收货人电话")
    private String receiverTel;


    @ApiModelProperty("优惠券id")
    private Long couponId;

    @ApiModelProperty("优惠券编码")
    private String couponCode;


    @ApiModelProperty("满减折扣id")
    private Long discountOffsetId;

    @ApiModelProperty("满减折扣编码")
    private String discountOffsetCode;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("物流评分")
    private String logicEvalScore;

    @ApiModelProperty("服务评分")
    private String serverEvalScore;

    @ApiModelProperty("是否同步OMS")
    private Boolean syncOms;
}
