package com.elitesland.sale.api.vo.resp.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/10/16:31
 * @Description:折扣信息VO--包含折扣主表和明细信息
 */
@ApiModel(description = "折扣信息")
@Data
public class BipDiscountOffsetVO implements Serializable {

    private static final long serialVersionUID = -8669568908892640768L;

    @ApiModelProperty(value = "折扣主表ID")
    private Long discountOffsetId;

    @ApiModelProperty(value = "折扣编码")
    private String code;

    @ApiModelProperty(value = "折扣名称")
    private String name;

    @ApiModelProperty(value = "折扣生效时间")
    private LocalDateTime validStime;

    @ApiModelProperty(value = "折扣失效时间")
    private LocalDateTime validEtime;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "'折扣计算类型 按件或者按照金额")
    private String type;

    @ApiModelProperty(value = "折扣匹配类型 商品或者品类")
    private String matchType;

    @ApiModelProperty(value = "折扣状态")
    private String status;

    @ApiModelProperty(value = "折扣明细ID")
    private Long Id;



    // 折扣明细
    @ApiModelProperty(value = "折扣商品ID")
    private Long itmeId;

    @ApiModelProperty(value = "折扣商品编码")
    private String itemCode;

    @ApiModelProperty(value = "折扣商品名称")
    private String itemName;
    @ApiModelProperty(value = "折扣分类id")

    private Long catId;
    @ApiModelProperty(value = "折扣分类编码")

    private String catCode;
    @ApiModelProperty(value = "折扣分类名称")
    private String catName;

    @ApiModelProperty(value = "折扣商品规格")
    private String itemAttr;

    @ApiModelProperty(value = "折扣商品计量单位")
    private String uom;

    @ApiModelProperty(value = "折扣达标最低金额")
    private BigDecimal limitAmt;

    @ApiModelProperty(value = "折扣达标最低件数")
    private Long limitNum;

    @ApiModelProperty(value = "折扣商品基本价格")
    private BigDecimal baseAmt;

    @ApiModelProperty(value = "折扣商品客户价格")
    private BigDecimal custAmt;

    @ApiModelProperty(value = "折扣免除金额")
    private BigDecimal freeAmt;

    @ApiModelProperty(value = "折扣后金额")
    private BigDecimal discountAmt;

    @ApiModelProperty(value = "商品总金额")
    private BigDecimal itemTotalAmt;

    @ApiModelProperty(value = "商品总件数")
    private Long itemTotalNum;




}
