package com.elitesland.sale.api.vo.param.pri;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Shadow（li qun）
 * @since 2021-12-27 13:46
 */
@Data
@ApiModel(description = "销售价格变更申请导出列")
public class SalePriceAlterExportVO implements Serializable {

    private static final long serialVersionUID = 6729464317038943661L;

    @ApiModelProperty(value = "申请单号")
    private String docNo;

    @ApiModelProperty(value = "申请类型")
    private String docType;
    private String docTypeName;

    @ApiModelProperty(value = "价格类型")
    private String priceType;
    private String priceTypeName;

    @ApiModelProperty(value = "公司")
    private Long ouId;
    private String ouName;

    @ApiModelProperty("申请")
    private Long applyEmpId;
    private String applyUserName;
    private LocalDateTime applyDate;
    private String applyDateStr;

    @ApiModelProperty(value = "区域")
    private String saleRegion;
    private String saleRegionName;

    @ApiModelProperty(value = "状态")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty(value = "商品")
    private Long itemId;
    private String itemCode;
    private String itemName;

    @ApiModelProperty(value = "商品规格")
    private String itemSpec;

    @ApiModelProperty(value = "条码")
    private String barcode;

    @ApiModelProperty(value = "商品品类码")
    private String itemCateCode;

    @ApiModelProperty(value = "单位")
    private String uom;
    private String uomName;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty("货币编码")
    private String currCode;
    private String currName;

    @ApiModelProperty(value = "生效时间")
    private LocalDateTime validFrom;
    private String validFromStr;

    @ApiModelProperty(value = "失效时间")
    private LocalDateTime validTo;
    private String validToStr;

    @ApiModelProperty(value = "活动价生效日期")
    private LocalDateTime promDateF;
    private String promDateFStr;

    @ApiModelProperty(value = "活动价失效日期")
    private LocalDateTime promDateT;
    private String promDateTStr;

    @ApiModelProperty("活动含税价格")
    private BigDecimal promotionPrice;

    @ApiModelProperty("活动不含税价格")
    private BigDecimal promotionNetPrice;

    @ApiModelProperty("创建者")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;
    private String createTimeStr;

    @ApiModelProperty("更新者")
    private String updater;

    @ApiModelProperty("更新时间")
    private LocalDateTime modifyTime;
    private String modifyTimeStr;

}
