package com.elitesland.sale.api.vo.param.shop;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class BipCouponQueryParam extends AbstractOrderQueryParam {


    private Long couponId;

    /**
     * 优惠券编码
     */
    @ApiModelProperty("优惠券编码")
    private String couponCode;

    /**
     * 生效时间
     */
    @ApiModelProperty("生效时间")
    private LocalDateTime validStime;

    /**
     * 失效时间
     */
    @ApiModelProperty("失效时间")
    private LocalDateTime validEtime;

    /**
     * 优惠券使用状态 未使用:NOTUSED   已使用:USED  已删除:DEL  已过期：OVERDUE
     */
    @ApiModelProperty("优惠券使用状态")
    private String useStatus;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;

    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long custId;


    /**
     * 所属公司名称
     */
    @ApiModelProperty("所属公司")
    private String ouName;

    /**
     * 优惠券类型
     */
    @ApiModelProperty("优惠券类型")
    private String type;

    /**
     * 优惠券使用类型，匹配品类  匹配商品
     */
    @ApiModelProperty("优惠券使用类型，匹配品类  匹配商品")
    private String matchType;



}
