package com.elitesland.sale.api.vo.resp.crm;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@ApiModel(description = "客户弹框选择")
@Data
public class CrmCustPlugInRespVO implements Serializable {

    private static final long serialVersionUID = -6749080322667143862L;
    @ApiModelProperty(value = "客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "客户类型")
    private String custType;

    @ApiModelProperty(value = "客户类型name")
    private String custTypeName;

    @ApiModelProperty(value = "业务员id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty(value = "业务员name")
    private String agentEmpName;

    @ApiModelProperty(value = "客户联系人")
    private String custContactName;

    @ApiModelProperty(value = "客户联系人电话")
    private String custContactTel;

    @ApiModelProperty(value = "客户联系人邮箱")
    private String custContactEmail;

    @ApiModelProperty(value = "客户组")
    private String custGroup;

    @ApiModelProperty(value = "币种")
    private String currCode;

    @ApiModelProperty(value = "客户联系人详细地址")
    private String addrDetail;

    @ApiModelProperty(value = "付款方式")
    private String payMethod;

    @ApiModelProperty(value = "付款方式Name")
    private String payMethodName;

    @ApiModelProperty(value = "付款条款")
    private String paymentTerm;

    @ApiModelProperty(value = "付款条款Name")
    private String paymentTermName;

    @ApiModelProperty(value = "地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long recvAddrNo;

    @ApiModelProperty(value = "地址ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrId;

    @ApiModelProperty(value = "收货国家")
    private String recvCountry;

    @ApiModelProperty(value = "收货省")
    private String recvProvince;

    @ApiModelProperty(value = "收货省名字")
    private String recvProvinceName;

    @ApiModelProperty(value = "收货市")
    private String recvCity;

    @ApiModelProperty(value = "收货市名字")
    private String recvCityName;

    @ApiModelProperty(value = "收货区/县")
    private String recvCounty;

    @ApiModelProperty(value = "收货区/县名字")
    private String recvCountyName;

    @ApiModelProperty(value = "收货乡镇街道")
    private String receiveStreet;

    @ApiModelProperty(value = "省市区街")
    private List<String> recvRegion;

    @ApiModelProperty(value = "区域")
    private String region;

    @ApiModelProperty(value = "区域Name")
    private String regionName;

    @ApiModelProperty(value = "项目公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "项目公司id")
    private String ouCode;

    @ApiModelProperty(value = "项目公司名称")
    private String ouName;
}
