package com.elitesland.sale.api.vo.resp.taskinfo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/20
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(description = "APP端任务的出参")
public class TaskInfoAppRespVO implements Serializable {
    private static final long serialVersionUID = 527003120563811724L;

    @ApiModelProperty("任务明细ID")
    private Long id;

    @ApiModelProperty("业务类型")
    @SysCode(sys = "yst-sale", mod = "TASK_BUSINESS_TYPE")
    private String businessType;
    private String businessTypeName;

    @ApiModelProperty("业务编码")
    private String businessCode;
    @ApiModelProperty("业务编码集合")
    private List<String> businessCodes;

    @ApiModelProperty(value = "客户号")
    private String custCode2;

    @ApiModelProperty("业务名称")
    private String businessName;

    @ApiModelProperty("国家")
    private String country;
    private String countryName;

    @ApiModelProperty("省")
    private String province;
    private String provinceName;

    @ApiModelProperty("市")
    private String city;
    private String cityName;

    @ApiModelProperty("区")
    private String district;
    private String districtName;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("完成状态")
    @SysCode(sys = "yst-sale", mod = "TASK_COMPLETION_STATUS")
    private String completeState;
    private String completeStateName;

    @ApiModelProperty("是否逾期")
    @SysCode(sys = "yst-sale", mod = "TASK_DELAY_FLAG")
    private String delayFlag;
    private String delayFlagName;

    @ApiModelProperty("执行记录id")
    private Long executRecordId;
    @ApiModelProperty("执行记录code")
    private String executRecordCode;
    @ApiModelProperty("执行记录名称")
    private String executRecordName;

    @ApiModelProperty("执行人")
    private String executUser;

    @ApiModelProperty("执行人id")
    private Long executUserId;

    @ApiModelProperty("执行人code")
    private String executUserCode;

    /************任务主表信息*************/

    @ApiModelProperty("任务主表ID")
    private Long masId;

    @ApiModelProperty("任务编码")
    private String code;

    @ApiModelProperty("任务名称")
    private String name;

    @ApiModelProperty("任务状态")
    @SysCode(sys = "yst-sale", mod = "SALESMAN_TASK_STATUS")
    private String state;
    private String stateName;

    @ApiModelProperty("任务进度")
    private BigDecimal progress;

    @ApiModelProperty("任务类型")
    @SysCode(sys = "yst-sale", mod = "SALESMAN_TASK_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("紧急程度")
    @SysCode(sys = "yst-sale", mod = "TASK_URGENCY_LEVEL")
    private String urgencyLevel;
    private String urgencyLevelName;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("强制签到")
    @SysCode(sys = "yst-sale", mod = "TASK_FORCE_SIGN_FLAG")
    private String forceSignFlag;
    private String forceSignFlagName;

    @ApiModelProperty("签到范围")
    private BigDecimal signInRange;

    @ApiModelProperty("签退范围")
    private BigDecimal signOutRange;

    @ApiModelProperty("执行模板code")
    private String executTemplateCode;
    @ApiModelProperty("执行模板名称")
    private String executTemplateName;

    /************任务主表信息*************/
}
