package com.elitesland.sale.api.vo.param.crm;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/4 13:24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "在客户表查询入参")
public class CrmScustQueryParamVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = -910874426684460004L;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户编码")
    private List<Long> custIds;

    @ApiModelProperty(value = "销售组织")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "地址号集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> addrNos;

    @ApiModelProperty(value = "业务员")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty(value = "所属公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "联系人电话")
    private String mobile;

    @ApiModelProperty(value = "CRM客户编码")
    private String custCode2;

    @ApiModelProperty(value = "简称")
    private String custAbbr;

    @ApiModelProperty(value = "联系人")
    private String contPerson;

    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;
}
