package com.elitesland.sale.api.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.sale.api.vo.resp.taskinfo.StatisticsDealerAppSumRespVO;
import com.elitesland.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;
import com.elitesland.sale.api.vo.save.SaleStatisticsDealerSaveVO;

import java.util.List;

/**
 * <p>
 * 功能说明:销售业绩统计-经销商
 * </p>
 *
 * @Author Darren
 * @Date 2023/06/01
 * @Version 1.0
 * @Content:
 */
public interface StatisticsDealerService {

    /**
     * 经销商销售业绩-批量新增
     *
     * @param saveVOList 入参
     * @return 出参对象
     */
    List<SaleStatisticsDealerRespVO> createBatch(List<SaleStatisticsDealerSaveVO> saveVOList);

    /**
     * 经销商销售业绩分页查询
     *
     * @param pageParam 入参
     * @return 经销商销售业绩信息集合
     */
    PagingVO<SaleStatisticsDealerRespVO> page(SaleStatisticsDealerQueryVO pageParam);

    /**
     * 经销商销售业绩分页查询-APP端
     *
     * @param pageParam 入参
     * @return 经销商销售业绩信息集合
     */
    PagingVO<SaleStatisticsDealerRespVO> appPage(SaleStatisticsDealerQueryVO pageParam);

    /**
     * 查询符合查询条件的已发生交易的经销商编码
     *
     * @param pageParam 入参
     * @return 经销商编码
     */
    List<String> statisticDealerCode(SaleStatisticsDealerQueryVO pageParam);

    /**
     * 经销商销售业绩统计汇总
     *
     * @param pageParam 入参
     * @return 统计汇总信息
     */
    StatisticsDealerSumRespVO pageSum(SaleStatisticsDealerQueryVO pageParam);

    /**
     * 经销商销售业绩统计汇总-APP端
     *
     * @param pageParam 入参
     * @return 统计汇总信息
     */
    StatisticsDealerSumRespVO appPageSum(SaleStatisticsDealerQueryVO pageParam);

    /**
     * 经销商销售业绩详情-头部信息和车型分页明细数据
     *
     * @param pageParam 入参
     * @return 经销商销售业绩详情信息
     */
    PagingVO<SaleStatisticsDealerRespVO> appDetails(SaleStatisticsDealerQueryVO pageParam);

    /**
     * 经销商销售业绩导出分页查询
     *
     * @param pageParam 入参
     * @return 经销商销售业绩信息集合
     */
    //PagingVO<SaleStatisticsDealerRespVO> exportPage(SaleStatisticsDealerQueryVO pageParam);

    /**
     * 经销商销售业绩根据业务员编码查询其当月的团队业绩和我的业绩
     *
     * @param empCodes 业务员编码
     * @return 信息集合
     */
    List<StatisticsDealerAppSumRespVO> appSumByEmpCode(List<String> empCodes);

    /**
     * 经销商销售业绩拉取订单数据并保存
     *
     * @param param 入参
     * @return
     */
    List<SaleStatisticsDealerRespVO> pullOrder(SaleStatisticsDealerQueryVO param);

    PagingVO<SaleStatisticsDealerRespVO> leaderPage(SaleStatisticsDealerQueryVO pageParam);

    StatisticsDealerSumRespVO leaderPageSum(SaleStatisticsDealerQueryVO pageParam);
}
