package com.elitesland.sale.api.vo.param.shop;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户客户绑定关系 查询VO
 * </p>
 *
 * @author ssy
 * @since 2021/9/6
 */
@ApiModel(description = "用户客户绑定关系 查询VO")
@Data
public class BipCustUserBindPageQueryVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = -5908757750333401681L;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("用户名，登录号")
    private String username;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("税务登记号")
    private String taxRegNo;

    @ApiModelProperty("联系人姓名")
    private String contactName;

    @ApiModelProperty("联系人电话")
    private String contactPhone;

    @ApiModelProperty("所属公司ID")
    private Long ouId;

    @ApiModelProperty("业务员ID")
    private Long agentEmpId;

    @ApiModelProperty("状态")
    private String state;

    @ApiModelProperty("申请状态")
    private String stateApply;

    @ApiModelProperty("注册时间")
    private LocalDateTime timeRegister;

}
