package com.elitesland.sale.api.vo.save.exter;

import com.elitesland.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/10/8 09:36
 */
@Data
@ApiModel(description = "销售项目保存")
public class SaleProjSaveDTO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -1451434467439662774L;

    @ApiModelProperty(value = "业务类型", required = true)
    @NotBlank(message = "业务类型不得为空")
    private String busiType;

    @ApiModelProperty(value = "渠道来源", required = true)
    @NotBlank(message = "渠道来源不得为空")
    private String channelType;

    @ApiModelProperty(value = "管理组织", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    @NotNull(message = "销售公司编码不得为空")
    private String ouCode;
    @NotNull(message = "销售公司名称不得为空")
    private String ouName;

    @ApiModelProperty(value = "bu组织", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    @NotNull(message = "bu组织不得为空")
    private String buCode;
    private String buName;

    @ApiModelProperty(value = "区域", required = true)
    @NotBlank(message = "区域不得为空")
    private String region;

    @ApiModelProperty(value = "客户id", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "客户编号", required = true)
    @NotBlank(message = "客户编号不得为空")
    private String custCode;

    @ApiModelProperty(value = "客户类型", required = true)
    @NotBlank(message = "客户类型不得为空")
    private String custType;

    @ApiModelProperty(value = "客户来源", required = true)
    @NotBlank(message = "客户来源不得为空")
    private String custSource;

    @ApiModelProperty(value = "客户名称", required = true)
    @NotBlank(message = "客户名称不得为空")
    private String custName;

    @ApiModelProperty(value = "客户地址", required = true)
    @NotBlank(message = "客户地址不得为空")
    private String custAddress;

    @ApiModelProperty(value = "客户性质", required = true)
    @NotBlank(message = "客户性质不得为空")
    private String custProp;

    @ApiModelProperty(value = "客户等级", required = true)
    @NotBlank(message = "客户等级不得为空")
    private String custLevel;

    @ApiModelProperty(value = "意向时间", required = true)
    @NotNull(message = "意向时间不得为空")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate intentTime;

    @ApiModelProperty(value = "财务属性", required = true)
    @NotBlank(message = "财务属性不得为空")
    private String finProp;

    @ApiModelProperty(value = "证件类型", required = true)
    @NotBlank(message = "证件类型不得为空")
    private String idType;

    @ApiModelProperty(value = "证件号码", required = true)
    @NotBlank(message = "证件号码不得为空")
    private String idNo;

    @ApiModelProperty(value = "证件失效日期", required = true)
    @NotNull(message = "证件失效日期不得为空")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate idExpireDate;

    @ApiModelProperty(value = "项目名称", required = true)
    @NotBlank(message = "项目名称不得为空")
    private String projName;

    @ApiModelProperty(value = "项目编号")
    private String projNo;

    @ApiModelProperty(value = "CRM项目编号")
    private String projNo2;

    @ApiModelProperty(value = "项目类型", required = true)
    @NotBlank(message = "项目类型不得为空")
    private String projType;

    @ApiModelProperty(value = "项目地址", required = true)
    @NotBlank(message = "项目地址不得为空")
    private String projAddress;

    @ApiModelProperty(value = "客户负责人", required = true)
    @NotBlank(message = "客户负责人不得为空")
    private String custPic;

    @ApiModelProperty(value = "客户负责人电话", required = true)
    @NotBlank(message = "客户负责人电话不得为空")
    private String custPicTel;

    @ApiModelProperty(value = "报装户数")
    private Long installNum;

    @ApiModelProperty(value = "报装日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate installDate;

    @ApiModelProperty(value = "施工时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate constructTime;

    @ApiModelProperty("施工资质要求")
    private String constructRequire;

    @ApiModelProperty(value = "施工验收时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate constructConfirmTime;

    @ApiModelProperty("施工验收标准")
    private String constructConfirmStandard;

    @ApiModelProperty(value = "项目招标时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate projBidsTime;

    @ApiModelProperty(value = "项目安装时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate projInstallTime;

    @ApiModelProperty(value = "项目开盘时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate projOpenTime;

    @ApiModelProperty("项目付款方式")
    private String projPayMethod;

    @ApiModelProperty(value = "通气时间")
    private LocalDate sameTime;

    @ApiModelProperty("客户类型(正式/潜在)")
    @SysCode(sys = "yst-sale",mod = "QT_TYPE")
    private String custType2;
    private String custType2Name;
}
