package com.elitesland.sale.api.vo.save.shop;

import java.time.LocalDateTime;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 订单表(BipRetationChart)实体类
 *
 * @author Shadow
 * @since 2021-08-11 15:08:53
 */

@Data
@ApiModel(value = "BipRetationChartSaveVO", description = "轮播图")
public class BipRetationChartSaveVO implements Serializable {
    private static final long serialVersionUID = 513734092134745833L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;
    /**
     * 满减折扣Id
     */
    @ApiModelProperty("满减折扣Id")
    private Long offsetId;
    /**
     * 满减折扣编码
     */
    @ApiModelProperty("满减折扣编码")
    private String offsetCode;
    /**
     * 满减去折扣名称
     */
    @ApiModelProperty("满减折扣名称")
    private String offsetName;
    /**
     * 满赠折扣Id
     */
    @ApiModelProperty("满赠折扣Id")
    private String giftId;
    /**
     * 满赠折扣编码
     */
    @ApiModelProperty("满赠折扣编码")
    private String giftCode;
    /**
     * 满赠折扣名称
     */
    @ApiModelProperty("满赠折扣名称")
    private String giftCname;
    /**
     * 描述
     */
    @ApiModelProperty("描述")
    private String retationDesc;
    /**
     * 优先级
     */
    @ApiModelProperty("优先级")
    private String priority;
    /**
     * 图片id
     */
    @ApiModelProperty("图片id")
    private Long picId;
    /**
     * 图片尺寸
     */
    @ApiModelProperty("图片尺寸")
    private String imageSize;
    /**
     * 轮播图停留时间，单位s
     */
    @ApiModelProperty("轮播图停留时间，单位s")
    private Long lastTime;
    /**
     * 开始时间
     */
    @ApiModelProperty("开始时间")
    private LocalDateTime stime;
    /**
     * 结束时间
     */
    @ApiModelProperty("结束时间")
    private LocalDateTime etime;

    @ApiModelProperty("状态 ACTIVE：启用  INACTIVE：停用  DRAFT：草稿")
    private String status;

}
