package com.elitesland.sale.api.service;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.sale.api.vo.param.pro.SalProjPagingParam;
import com.elitesland.sale.api.vo.param.pro.SalProjQueryParam;
import com.elitesland.sale.api.vo.param.pro.SalProjSaveParam;
import com.elitesland.sale.api.vo.resp.pro.SalProjDetailRespVO;
import com.elitesland.sale.api.vo.resp.pro.SalProjPageRespVO;
import com.elitesland.sale.api.vo.resp.pro.SalProjSimpleRespVO;
import com.elitesland.sale.api.vo.save.SalContractImportSaveVO;
import com.elitesland.sale.api.vo.save.SalProjImportSaveVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/8 9:06 上午
 */
public interface SalProjService {

    /**
     * 根据查询条件分页查询项目信息列表
     * @param pageParam 查询条件
     * @return
     */
    PagingVO<SalProjPageRespVO> query(SalProjPagingParam pageParam);

    /**
     * 保存或更新项目信息
     * @param param 参数
     * @return
     */
    JSONObject save(SalProjSaveParam param);

    /**
     * 根据项目ID获取项目详情
     * @param id 项目ID
     * @return
     */
    SalProjDetailRespVO queryOneDetail(Long id);

    /**
     * 批量逻辑删除项目
     * @param ids
     */
    void delSalProj(List<Long> ids);

    /**
     * 根据参数查询项目
     * @param param 请求参数
     * @return
     */
    List<SalProjSimpleRespVO> queryByParam(SalProjQueryParam param);

    /**
     * 销售项目导入
     * @param parseData
     * @return
     */
    ApiResult<Object> projImportData(List<SalProjImportSaveVO> parseData);
}
