package com.elitesland.sale.api.vo.resp.pro;

import com.elitesland.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 返回参数 - 合同验收单查询返回
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-22 09:57:48
 */
@ApiModel(description = "合同验收单查询返回详细信息")
@Data
public class SalAcceptanceDetailRespVO implements Serializable {

    private static final long serialVersionUID = -3506753293379745998L;

    @ApiModelProperty("验收单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("验收单号")
    private String docNo;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    private String ouName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty(value = "组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    private String buName;

    @ApiModelProperty(value = "客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "合同ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long contractId;

    @ApiModelProperty(value = "合同编号")
    private String contractNo;

    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-sale", mod = "SAL_AC_STATUS")
    private String acStatus;
    private String acStatusName;

    @ApiModelProperty("申请日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyDate;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("申请人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;

    @ApiModelProperty("申请人name")
    private String applyEmpName;

    @ApiModelProperty("验收金额（含税）")
    private BigDecimal amt;

    @ApiModelProperty(value="验收金额（不含税）", required = true)
    private BigDecimal netAmt;

    @ApiModelProperty(value = "验收税额", required = true)
    private BigDecimal taxAmt;

    @ApiModelProperty("验收日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate acDate;

    @ApiModelProperty("审批意见")
    private String apprComment;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("附件信息")
    List<ComSaleFileComVO> fileComVOS;

    @ApiModelProperty("验收单明细")
    private List<SalAcceptanceDDetailRespVO> details;


}
