package com.elitesland.sale.dto.query;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author Danny.Wang
 * @title SalesmanQueryDTO
 * @Date2023/3/2 9:54
 */
@Data
public class SalesmanAPPQueryDTO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = -6531278671345822763L;

    /**
     * 业务员编码
     */
    @ApiModelProperty("业务员编码，不传查所有业务员信息")
    private String salesmanCode;

    /**
     * 第一次查询,第一次调用赋值为1，只查询自己的信息，否则赋值为0
     */
    @ApiModelProperty("是否为第一次查询，第一次调用赋值为1，只查询自己的信息，否则赋值为0")
    private Integer one;

    /**
     * 是否级联查询下级所有下属,默认为false
     */
    @ApiModelProperty("是否级联查询下级所有下属，默认为false")
    private Boolean cascade = false;

    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("统计月份(yyyy-MM)")
    private String docMonth;
}
