package com.elitesland.sale.api.vo.resp.com;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 附件信息
 *
 * @author zhao.zhi.hao
 * @since 2021/6/5 14:11
 */
@ApiModel(description = "附件信息")
@Data
public class ComSaleFileComVO implements Serializable {

    private static final long serialVersionUID = 7091629778171739631L;

    @ApiModelProperty("证件编号")
    private String qualifyNo;

    @ApiModelProperty("业务关联ID")
    private Long businessId;

    @ApiModelProperty("业务类型")
    private String businessType;

    @ApiModelProperty("文件ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long fileId;

    @ApiModelProperty("文件名称")
    private String originalName;

    @ApiModelProperty("文件编号")
    private String fileCode;

    @ApiModelProperty("文件类型(图片，附件等)")
    private String fileType;

    @ApiModelProperty("图片尺寸")
    private String imgSize;

    @ApiModelProperty("文件大小")
    private String fileSize;

    @ApiModelProperty("是否主图")
    private Boolean major;

    @ApiModelProperty("附件备注")
    private String remark;


}