package com.elitesland.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/01
 */
@Data
@ApiModel(description = "用户注册")
public class BipCustUserRegisterSaveVO implements Serializable {
    private static final long serialVersionUID = 8326049276418812626L;

    @ApiModelProperty(value = "用户手机号码", required = true, position = 1)
    @NotBlank(message = "手机号不能为空")
    private String mobile;

    @ApiModelProperty(value = "密码", required = true, position = 2)
    @NotBlank(message = "密码不能为空")
    private String password;

    @ApiModelProperty(value = "验证码", required = true, position = 3)
    @NotBlank(message = "验证码不能为空")
    private String captcha;
}
