package com.elitesland.sale.api.vo.param.pri;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 请求参数 - 价格申请审批
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 2:13 下午
 */
@Data
@ApiModel(description = "价格申请审批参数")
public class PriSalePriceApproveParam implements Serializable {

    @ApiModelProperty(value = "申请单ID", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull(message = "申请单ID不得为空")
    private Long docId;

    @ApiModelProperty(value = "审批状态", required = true)
    @NotBlank(message = "审批状态不得为空")
    private String apprStatus;

    @ApiModelProperty(value = "审批意见")
    private String apprComment;

}
