package com.elitesland.sale.api.vo.resp.salesman;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author Danny.Wang
 * @title SalesmanDetailInfoRespVO
 * @Date2023/3/1 19:22
 */
@Data
public class SalesmanDetailInfoRespVO implements Serializable {
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("业务员编号")
    private String salesmanNo;

    @ApiModelProperty("业务员类型")
    private String salesmanType;

    @ApiModelProperty("业务员类型名称")
    private String salesmanTypeName;

    @ApiModelProperty("管辖区域")
    private String jurisdiction;

    @ApiModelProperty("管辖区域名称")
    private String jurisdictionName;

    @ApiModelProperty("启用状态")
    private Integer enableStatus;

    @ApiModelProperty("启用状态名称")
    private String enableStatusName;

    @ApiModelProperty("公司名称")
    private String ouName;


    /**
     * 入职时间
     */
    private LocalDateTime joinTime;

    /**
     * 用户账号
     */
    private String username;

    /**
     * 姓名
     */
    private String fullName;

    /**
     * 性别
     * {@link com.elitescloud.cloudt.common.constant.Gender}
     */
    private String gender;
    private String genderName;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 办公电话、手机号
     */
    private String phone;

    /**
     * 生日
     */
    private String birthDate;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 省份名称
     */
    @ApiModelProperty(value = "省份名称", position = 1)
    private String provinceName;

    /**
     * 市名称
     */
    @ApiModelProperty(value = "市名称", position = 2)
    private String cityName;

    /**
     * 县名称
     */
    @ApiModelProperty(value = "县名称", position = 3)
    private String countyName;

    /**
     * 地址
     */
    private String address;

    /**
     * 组织ID
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;


    /**
     * 上级领导姓名
     */
    private String leaderUserFullName;

}
