package com.elitesland.sale.api.vo.param.mdmSync;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/23 13:46
 */
@Data
@EqualsAndHashCode()
@ApiModel(description = "MDM客户查询主数据入参")
public class CrmCustMdmSyncDataParamVO implements Serializable {

    private static final long serialVersionUID = -2233863759540643396L;

    @ApiModelProperty(value = "申请系统名称")
    private String applicationCode;

    @ApiModelProperty(value = "固定参数")
    private String ifaceCode;

    @ApiModelProperty(value = "客户编码")
    private String custNo;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "创建时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "税务登记号")
    private String licenseNo2;

    @ApiModelProperty(value = "批次")
    @JsonSerialize(using = ToStringSerializer.class)
    private String batch;

    @ApiModelProperty(value = "历史批次号")
    private String batchHistory;

    @ApiModelProperty(value = "页数")
    private Integer pageNumber;
}
