package com.elitesland.sale.api.service.shop;

import com.elitesland.sale.api.vo.param.shop.BipOrderBackParmVO;
import com.elitesland.sale.api.vo.param.shop.app.BipOrderBackUserParmVO;
import com.elitesland.sale.api.vo.resp.shop.BipOrderBackRespVO;
import com.elitesland.sale.api.vo.save.shop.BipOrderBackLogistSaveVO;
import com.elitesland.sale.api.vo.save.shop.BipOrderBackSaveVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/21/17:22
 * @Description:
 */
public interface BipOrderBackService {

    /**
     * 保存退款单
     * @param bipOrderBackSaveVO 保存参数
     * @param orderBackIds 退款单id
     */
    void saveBipOrderBack(BipOrderBackSaveVO bipOrderBackSaveVO, List<Long> orderBackIds);

    /**
     * 创建退款单
     * @param bipOrderBackSaveVO 创建参数
     */
    void createOrderBack(BipOrderBackSaveVO bipOrderBackSaveVO);

    /**
     * 分页查询退款单
     * @param bipOrderBackParmVO 查询参数
     * @return 退款单列表
     */
    PagingVO<BipOrderBackRespVO> findBipOrderBackPage(BipOrderBackParmVO bipOrderBackParmVO);

    /**
     * 修改退款单并同步到OMS
     * @param bipOrderBackSaveVO 修改参数
     */
    void updateSync(BipOrderBackSaveVO bipOrderBackSaveVO);

    /**
     * 取消退款单并同步到OMS
     * @param id 主表ID
     */
    void cancelSync(Long id);

    /**
     * 批量删除退款单
     * @param ids 退款单列表
     */
    void deleteBipOrderBackByIds(List<Long> ids);

    /**
     * 查询订单聚合信息
     *
     * @param orderBackId
     * @return
     */
    BipOrderBackRespVO findPolymerizeOrderBack(Long orderBackId);

    /**
     * 查询用户退货单列表
     *
     * @param bipOrderBackUserParmVO
     * @return
     */
    PagingVO<BipOrderBackRespVO> findUserOrderBack(BipOrderBackUserParmVO bipOrderBackUserParmVO);

    /**
     * 查询退货单详情通过id
     *
     * @param id
     * @return
     */
    BipOrderBackRespVO findOrderBackDetailById(Long id);

    /**
     * 跟新退货单物流信息
     *
     * @param bipOrderBackLogistSaveVO
     */
    void updateOrderBackLogistInfo(BipOrderBackLogistSaveVO bipOrderBackLogistSaveVO);

    /**
     * 跟新退货单审核装填
     *
     * @param bipOrderBackSaveVO
     */
    void updateCheckStatus(BipOrderBackSaveVO bipOrderBackSaveVO);

    /**
     * 提交开启退货单工作流
     *
     * @param bipOrderBackSaveVO bipOrderBackSaveVO
     */
    void submit(BipOrderBackSaveVO bipOrderBackSaveVO);

    /**
     * 撤销申请
     *
     * @param id
     */
    void cancle(Long id);

    /**
     * 再次申请
     *
     * @param id
     */
    void reBack(Long id);

}
