package com.elitesland.sale.api.vo.param.shop;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/27
 */
@Data
@ApiModel(description = "上架商品查询参数")
public class BipItemOnShelfQueryParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -3319484036828102748L;

    @ApiModelProperty(value = "上架编码", position = 1)
    private String shelfCode;

    @ApiModelProperty(value = "创建人ID", position = 2)
    private Long createUserId;

    @ApiModelProperty(value = "创建人名称", position = 3)
    private String creator;

    @ApiModelProperty(value = "所属公司ID", position = 4)
    private Long ouId;

    @ApiModelProperty(value = "状态，待审核、已拒绝、已上架、待下架", position = 5)
    private String state;

    @ApiModelProperty(value = "商品编码", position = 6)
    private String itemCode;

    @ApiModelProperty(value = "商品名称", position = 7)
    private String itemName;

    @ApiModelProperty(value = "一级商品分类ID", position = 8)
    private Long categoryId1;

    @ApiModelProperty(value = "二级商品分类ID", position = 9)
    private Long categoryId2;

    @ApiModelProperty(value = "三级商品分类ID", position = 10)
    private Long categoryId3;

    @ApiModelProperty(value = "运费收费方式 - 是否包邮", position = 11)
    private Boolean fareFree;
}
