package com.elitesland.sale.api.vo.param.shop;

import com.elitesland.sale.api.AmtBigDecimalJsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 满减促销赠折扣信息明细 保存VO
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
@ApiModel(description = "满减促销赠折扣信息明细 保存VO")
@Data
public class MktDiscountGiftDSaveVO implements Serializable {

    private static final long serialVersionUID = -6736071199158601304L;

    @ApiModelProperty("明细表ID")
    private Long id;

    @ApiModelProperty("折扣赠满减ID")
    private Long mktDiscountGiftId;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品规格")
    private String itemAttr;

    @ApiModelProperty("计量单位")
    private String uom;

    @JsonDeserialize(using = AmtBigDecimalJsonDeserialize.class)
    @ApiModelProperty("满赠达标金额")
    private BigDecimal limitAmt;

    @ApiModelProperty("满赠达标数量")
    private Long limitNum;

    @ApiModelProperty("折扣编码")
    private String discountGiftCode;

    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

}
