package com.elitesland.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/20
 */
@Data
@ApiModel(description = "商品图片")
public class BipItemPicSaveVO implements Serializable {
    private static final long serialVersionUID = -3130162751585962774L;

    @ApiModelProperty(value = "文件的唯一标识", position = 1, required = true)
    @NotBlank(message = "图片的标识为空")
    private String fileCode;

    @ApiModelProperty(value = "文件大小", position = 2)
    private Long fileSize;

    @ApiModelProperty(value = "文件名称", position = 3)
    @Size(message = "文件名称的长度限制为256")
    private String fileName;

    @ApiModelProperty(value = "文件的mime-type", position = 4)
    @NotBlank(message = "未知文件的类型")
    private String mimeType;

    @ApiModelProperty(value = "是否是主图", position = 5, required = true)
    @NotNull(message = "主图不能为空")
    private Boolean main;

    @ApiModelProperty(value = "图片的可访问链接", position = 6, required = true)
    private String url;
}
