package com.elitesland.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.Application;
import com.elitesland.sale.dto.SalemanCustDTO;
import com.elitesland.sale.dto.SalesmanInfoDTO;
import com.elitesland.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.sale.dto.query.SalesmanAPPQueryDTO;
import com.elitesland.sale.dto.query.SalesmanInfoAPPRespDTO;
import com.elitesland.sale.dto.query.SalesmanQueryDTO;
import com.elitesland.sale.dto.save.SalesmanUpdateDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Danny.Wang
 * @title SalesmanRpcService
 * @Date2023/3/2 9:32
 */
@FeignClient(name = Application.NAME, path = SalesmanRpcService.URI)
public interface SalesmanRpcService {
    String URI = Application.URI_PREFIX + "/salesman";

    /**
     * 根据业务员id 或者 业务员编码查询业务员信息
     * @param salesmanQueryDTO
     * @return
     */
    @PostMapping("/salesman/query")
    ApiResult<SalesmanInfoDTO> querySalesmanInfo(@RequestBody SalesmanQueryDTO salesmanQueryDTO);

    /**
     * 根据多个业务员id 或者 多个业务员编码查询业务员信息
     * @param salesmanQueryDTO
     * @return
     */
    @PostMapping("/salesman/query/list")
    ApiResult<List<SalesmanInfoDTO>> querySalesmanInfoList(@RequestBody SalesmanQueryDTO salesmanQueryDTO);

    /**
     * 更改用户头像文件
     * @param salesmanUpdateDTO
     * @return
     */
    @PostMapping("/salesman/update")
    ApiResult<Object> updateSalesmanInfo(@RequestBody SalesmanUpdateDTO salesmanUpdateDTO);

    /**查询业务员的团队信息
     * @param salesmanAPPQueryDTO
     * @return SalesmanInfoAPPRespDTO
     */
    @PostMapping("/salesmanTeam")
    ApiResult<SalesmanInfoAPPRespDTO> salesmanTeam(@RequestBody SalesmanAPPQueryDTO salesmanAPPQueryDTO);


    @GetMapping("/getSalemanCust")
    ApiResult<SalemanCustDTO> getSalemanCust(@RequestParam("id") Long id);

    @GetMapping("/queryLevelData/{id}")
    ApiResult<SalesmanLevelInfoDTO> queryLevelInfo(@PathVariable("id") Long id);
}
