package com.elitesland.sale.api.service;

import com.elitesland.sale.api.vo.param.logistics.LogisticsTemplateParam;
import com.elitesland.sale.api.vo.param.logistics.LogisticsTemplateSaveParam;
import com.elitesland.sale.api.vo.param.logistics.TemplateDetailComputeParam;
import com.elitesland.sale.api.vo.resp.logistics.BaseAreaVO;
import com.elitesland.sale.api.vo.resp.logistics.LogisticsTemplateDVO;
import com.elitesland.sale.api.vo.resp.logistics.LogisticsTemplateVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

public interface LogisticsTemplateService {

    LogisticsTemplateVO findCouponById(Long id);

    PagingVO<LogisticsTemplateVO> findPagingResult(LogisticsTemplateParam logisticsTemplateParam);

    ApiResult<Object> saveLogistics(LogisticsTemplateSaveParam logisticsTemplateParam);

    ApiResult<Object> delLogistics(List<Long> ids);

    ApiResult<Object> openLogistics(List<Long> id);

    ApiResult<Object> stopLogistics(List<Long> id);

    List<BaseAreaVO> getProvince();

    List<BaseAreaVO> getCityByProvince(Long id);

    /**
     * 查询两个市之间的运费信息
     * @param templateDetailComputeParam
     * @return
     */
    LogisticsTemplateDVO getTemplateDetail(TemplateDetailComputeParam templateDetailComputeParam);

}
