package com.elitesland.sale.api.vo.param.salesman;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;


/**
 * <p>
 * 业务员下级查询参数：
 * </p>
 *
 * @author ssy
 * @since 2023/8/17
 */
@Data
@ApiModel("业务员下级查询参数")
public class SalesmanUnderLingQueryVO extends AbstractOrderQueryParam {

    @ApiModelProperty(value = "员工编号",required = true)
    @NotBlank(message = "员工编号不允许为空")
    private String code;

    @ApiModelProperty(value = "员工编号、名称，模糊查询")
    private String  salemanNoNameLike;

    @ApiModelProperty(value = "本级及下级员工编号集合",required = true)
    @JsonIgnore
    private List<String> underlingCodes;
}
