package com.elitesland.sale.api.vo.resp.crm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@ApiModel(description = "客户信息")
@Data
public class CrmCustSimpleVO implements Serializable {
    private static final long serialVersionUID = -3388911650082570129L;

    @ApiModelProperty(value = "客户ID")
    private Long id;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户类型")
    private String custType;

    @ApiModelProperty(value = "客户归类")
    private String custType2;
    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "地址号")
    private Long addrNo;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "客户号")
    private String custCode2;

    @ApiModelProperty(value = "税务登记证编号")
    private String taxRegNo;

    @ApiModelProperty(value = "外部系统编码")
    private String outerCode;


    @ApiModelProperty(value = "区域")
    private String region;

    @ApiModelProperty(value = "省")
    private String provinceCode;

    private String custCurr;

    private String pid;


    @ApiModelProperty(value = "对应公司")
    private String corOu;

    @ApiModelProperty("业务类型UDC[yst-sale:BUSINESS_TYPE]")
    private String businessTypeCust;

}
