package com.elitesland.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @auther xkh
 * @date 2022/3/2 15:30
 */

@Data
@ApiModel(description = "客户对账单参数(通用)")
public class SalSoaExportPageVO implements Serializable {
    private static final long serialVersionUID = 2275002854128472081L;

    @ApiModelProperty(value = "对账单号")
    private String docNo;

    @ApiModelProperty(value = "对账日期")
    private LocalDateTime soaDate;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户联系人")
    private String custPic;

    @ApiModelProperty(value = "客户联系人电话")
    private String custPicTel;

    @ApiModelProperty(value = "对账含税金额")
    private BigDecimal soaAmt;

    @ApiModelProperty(value = "申请人姓名")//注意：客户查账查询接口未查到对账人，因此使用申请人作为对账人
    private String applyName;

    @ApiModelProperty(value = "申请人电话")//同上
    private String applyEmpTel;

    @ApiModelProperty(value = "行号")//SalSoaDRespVO
    private BigDecimal lineNo;

    @ApiModelProperty(value = "发货单编号")//SalSoaDRespVO
    private Long dodId;

    @ApiModelProperty(value = "发货时间")//SalSoaDRespVO
    private LocalDateTime docTime;

    @ApiModelProperty(value = "签收日期")//SalSoaDRespVO
    private LocalDateTime confirmTime;

    @ApiModelProperty(value = "商品名称2")//SalSoaDRespVO
    private String itemName;

    @ApiModelProperty(value = "商品规格")//SalSoaDRespVO
    private String itemSpec;

    @ApiModelProperty(value = "发货数量")//SalSoaDRespVO
    private BigDecimal doQty;

    @ApiModelProperty(value = "实发数量")//SalSoaDRespVO
    private BigDecimal doQty2;

    @ApiModelProperty(value = "签收数量")//SalSoaDRespVO
    private BigDecimal confirmQty;

    @ApiModelProperty(value = "签收含税金额")//SalSoaDRespVO
    private BigDecimal confirmAmt;

    @ApiModelProperty(value = "单位")
    @SysCode(sys = "yst-supp", mod = "UOM")//SalSoaDRespVO
    private String soUom;
    private String soUomName;

    @ApiModelProperty(value = "发货含税金额")//SalSoaDRespVO
    private BigDecimal doAmt;

    @ApiModelProperty(value = "含税单价")//SalSoaDRespVO
    private BigDecimal doPrice;
}
