package com.elitesland.sale.api.service.shop;


import com.elitesland.sale.api.vo.param.shop.BipInvCreateParam;
import com.elitesland.sale.api.vo.param.shop.BipInvQueryParam;
import com.elitesland.sale.api.vo.param.shop.BipInvViewAndDownParam;
import com.elitesland.sale.api.vo.resp.shop.BipInvVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Joker (Xing Shixiang)
 * @since 2021-09-06 13:51:23
 */
public interface BipInvService {
    /**
     * @param param 开发票入参
     * @return 发票ID
     */
    ApiResult<List<String>> createInv(BipInvCreateParam param);

    /**
     * @param param 根据id查询所有该id下的发票--暂时传入
     * @return 该用户的发票
     */
    PagingVO<BipInvVO> appFindAll(BipInvQueryParam param);

    /**
     * @param to address
     * @param invId id
     * @return 结果
     */
    ApiResult<Long> sendEmail(String to, Long invId);

    /**
     * @param invId 根据发票id查询该发票的详细信息
     * @return 该发票id下的发票
     */
    BipInvVO findByInvId(Long invId);

    /**
     *
     * @param param 查询发票入参
     * @return param
     */
    PagingVO<BipInvVO> findAllByParam(BipInvQueryParam param);

    /**
     * 根据订单id查该订单下的发票
     * @param orderId 订单id
     * @return param
     */
    List<BipInvVO> findInvByOrderId(Long orderId);
    /**
     * 红冲
     * @param orderId 订单id
     * @return param
     */
    Long creditInv(Long orderId);
    /**
     * 红冲
     * @param orderId 订单id
     * @return param
     */
    Long uReditInv(Long orderId);

    /**
     * 根据订单号,查询发票信息并下载
     * @param bipInvViewAndDownParam bipInvViewAndDownParam
     * @return String
     */
    ApiResult<List<String>> viewAndDownload(BipInvViewAndDownParam bipInvViewAndDownParam);
    /**
     * 根据订单号,查询发票信息并下载
     * @param invSerialNum invSerialNum
     * @return PDF url
     */
    ApiResult<String> findInvByInvSerialNum(String invSerialNum);
}


