package com.elitesland.sale.api.vo.resp.shop;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/10/19:05
 * @Description:满赠折扣
 */
@Data
public class BipDiscountGiftVO {

    private static final long serialVersionUID = -8669568908892640768L;

    @ApiModelProperty(value = "折扣主表ID")
    private Long discountOffsetId;

    @ApiModelProperty(value = "折扣编码")
    private String code;

    @ApiModelProperty(value = "折扣名称")
    private String name;

    @ApiModelProperty(value = "折扣生效时间")
    private LocalDateTime validStime;

    @ApiModelProperty(value = "折扣失效时间")
    private LocalDateTime validEtime;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "'折扣计算类型 按件或者按照金额")
    private String type;

    @ApiModelProperty(value = "折扣匹配类型 商品或者品类")
    private String matchType;

    @ApiModelProperty(value = "折扣状态")
    private String status;

    @ApiModelProperty(value = "折扣明细ID")
    private Long Id;



    // 折扣明细
    @ApiModelProperty(value = "折扣商品ID")
    private Long itmeId;

    @ApiModelProperty(value = "折扣商品编码")
    private String itemCode;

    @ApiModelProperty(value = "折扣商品名称")
    private String itemName;
    @ApiModelProperty(value = "折扣分类id")

    private Long catId;
    @ApiModelProperty(value = "折扣分类编码")

    private String catCode;
    @ApiModelProperty(value = "折扣分类名称")
    private String catName;

    @ApiModelProperty(value = "折扣商品规格")
    private String itemAttr;

    @ApiModelProperty(value = "折扣商品计量单位")
    private String uom;

    @ApiModelProperty(value = "折扣达标最低金额")
    private BigDecimal limitAmt;

    @ApiModelProperty(value = "折扣达标最低件数")
    private Long limitNum;


    @ApiModelProperty(value = "赠品ID")
    private Long giftId;

    @ApiModelProperty(value = "赠送数量")
    private Long giftNum;

    @ApiModelProperty(value = "商品总金额")
    private BigDecimal itemTotalAmt;

    @ApiModelProperty(value = "商品总件数")
    private Long itemTotalNum;


}
