package com.elitesland.sale.api.vo.resp.shop;

import com.elitesland.sale.api.AmtBigDecimalJsonSerialize;
import com.elitesland.sale.api.PriceBigDecimalJsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 满减折扣-明细VO
 * </p>
 *
 * @author ssy
 * @since 2021/8/19
 */
@ApiModel(description = "满减折扣-明细VO")
@Data
public class MktDiscountOffsetRespDVO implements Serializable {

    private static final long serialVersionUID = 4712779359960525577L;
    @ApiModelProperty(value = "折扣明细表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "折扣主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long mktDiscountOffsetId;

    @ApiModelProperty(value = "商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "商品规格")
    private String itemAttr;

    @ApiModelProperty(value = "计量单位")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "满减达标金额")
    @JsonSerialize(using = AmtBigDecimalJsonSerialize.class)
    private BigDecimal limitAmt;

    @ApiModelProperty(value = "满减达标数量")
    private Long limitNum;

    @ApiModelProperty(value = "基础价格")
    @JsonSerialize(using = PriceBigDecimalJsonSerialize.class)
    private BigDecimal basePrice;

    @ApiModelProperty(value = "客户价格")
    @JsonSerialize(using = PriceBigDecimalJsonSerialize.class)
    private BigDecimal custPrice;

    @ApiModelProperty(value = "减免金额")
    @JsonSerialize(using = AmtBigDecimalJsonSerialize.class)
    private BigDecimal freeAmt;

    @ApiModelProperty(value = "折扣后价格")
    @JsonSerialize(using = PriceBigDecimalJsonSerialize.class)
    private BigDecimal discountPrice;
}
