package com.elitesland.sale.api.vo.param.taskinfo;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-5-19
 * @desc : 销售业绩统计-门店
 */
@Data
@ApiModel(description = "销售业绩统计-门店")
public class SaleStatisticsStoreQueryVO extends AbstractOrderQueryParam {
    /**
     * 统计时间
     */
    @ApiModelProperty("统计时间")
    private LocalDateTime docTime;
    /**
     * 统计时间
     */
    @ApiModelProperty("统计开始时间")
    private LocalDateTime docTimeStart;

    @ApiModelProperty("统计结束时间")
    private LocalDateTime docTimeEnd;

    @ApiModelProperty("统计月份(yyyy-MM)")
    private String docMonth;


    @ApiModelProperty("统计时间起始")
    @JsonIgnore
    private Integer docTimeItStart;
    @ApiModelProperty("统计时间截至")
    @JsonIgnore
    private Integer docTimeItEnd;

    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    private String storeCode;

    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    private String storeName;

    /**
     * 经销商编码
     */
    @ApiModelProperty("经销商编码")
    private String dealerCode;

    /**
     * 经销商编码
     */
    @ApiModelProperty("经销商编码集合")
    private List<String> dealerCodeList;

    @ApiModelProperty("所属客户编码/名称模糊查询")
    private String dealerKeyword;

    /**
     * 经销商名称
     */
    @ApiModelProperty("经销商名称")
    private String dealerName;

    /**
     * 经销商客户号
     */
    @ApiModelProperty("经销商客户号")
    private String dealerSerialNo;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty("区域是否为空(下拉选项，是/否，判断区域字段是否为null)")
    private String regionEmptyFlag;

    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String type;

    /**
     * 业务员关系路径
     */
    @ApiModelProperty("业务员关系路径")
    private String salesmanPath;

    @ApiModelProperty("业务员关系路径是否为空(下拉选项，是/否，判断业务员关系路径字段是否为null)")
    private String salesmanPathEmptyFlag;

    /**
     * 车型
     */
    @ApiModelProperty("车型")
    private String vehicleType;

    /**
     * 整车类型
     */
    @ApiModelProperty("整车类型")
    private String itemType3;

    /**
     * 出货量
     */
    @ApiModelProperty("出货量")
    private BigDecimal shipQty;

    /**
     * ids
     */
    @ApiModelProperty("ids")
    private List<Long> ids;
    /**
     * id
     */
    @ApiModelProperty("id")
    private Long id;

    /**
     *业务员名称
     */
    @ApiModelProperty(value = "所属业务员编码")
    private String agentEmp;
    @ApiModelProperty(value = "所属业务员编码集合")
    private List<String> agentEmpList;

    /**
     * 经营性质
     */
    @ApiModelProperty(value = "经营性质")
    private String storeType2;

    /**
     * 门店详细地址
     */
    @ApiModelProperty(value = "门店详细地址")
    private String detailAddr;


    @ApiModelProperty("层级：  0——默认是客户所属的业务员  1、2、...——依次往上查询上级赋值")
    private String level;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("查看自己:true 查看自己,false 查看团队")
    private Boolean seeSelf;


    /**
     * 客服编号
     */
    @ApiModelProperty(value = "客服编号")
    private String empCode;

    /**
     * 客服姓名
     */
    @ApiModelProperty(value = "客服姓名")
    private String empName;

    /**
     * 用户id2
     */
    @ApiModelProperty(value = "(客服)用户id2")
    private Long userId2;

    @ApiModelProperty("汇总出货量 左区间")
    private BigDecimal shipTotalQtyFrom;
    @ApiModelProperty("汇总出货量 右区间")
    private BigDecimal shipTotalQtyTo;

}