package com.elitesland.sale.api.vo.resp.taskinfo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-6-1
 * @desc : 销售业绩统计-经销商
 */

@Data
@ApiModel(description = "销售业绩统计-经销商")
public class SaleStatisticsDealerRespVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 5119111630328961722L;

    /**
     * 统计时间
     */
    @ApiModelProperty("统计时间")
    private LocalDateTime docTime;
    @ApiModelProperty("统计月份(yyyy-MM)")
    private String docMonth;
    @ApiModelProperty("统计时间(yyyy-MM-dd)")
    private String docDay;
   /* @ApiModelProperty("统计月份")
    private Integer yearMonth;*/

    /**
     * 经销商编码
     */
    @ApiModelProperty("经销商编码")
    private String dealerCode;

    /**
     * 经销商名称
     */
    @ApiModelProperty("经销商名称")
    private String dealerName;

    /**
     * 经销商客户号
     */
    @ApiModelProperty("经销商客户号")
    private String dealerSerialNo;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    @SysCode(sys = "yst-supp", mod = "REGION")
    private String region;
    private String regionName;
    /**
     * 类型
     */
    @ApiModelProperty("类型")
    @SysCode(sys = "yst-sale",mod = "STATISTICS_TYPE")
    private String type;
    private String typeName;

    /**
     * 业务员关系路径
     */
    @ApiModelProperty("业务员关系路径")
    private String salesmanPath;

    /**
     * 车型
     */
    @ApiModelProperty("车型")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE5")
    private String vehicleType;
    private String vehicleTypeName;
    /**
     * 出货量
     */
    @ApiModelProperty("出货量")
    private BigDecimal shipQty;
    @ApiModelProperty("汇总出货量")
    private BigDecimal shipTotalQty;
    /**
     * 订货量
     */
    @ApiModelProperty("订货量")
    private BigDecimal orderQty;
    @ApiModelProperty("汇总订货量")
    private BigDecimal orderTotalQty;
    /**
     * 客户类型
     */
    @ApiModelProperty("客户类型")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE")
    private String custType;
    private String custTypeName;

    /**
     * 整车类型
     */
    @ApiModelProperty("整车类型")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE3")
    private String itemType3;
    private String itemType3Name;

    @ApiModelProperty("业务员明细")
    private List<SaleStatisticsDealerDtlRespVO> dtlRespVOS;

    @ApiModelProperty(value = "所属业务员编码")
    private String agentEmp;
    @ApiModelProperty(value = "业务员名称")
    private String agentEmpName;

    @ApiModelProperty("上级1")
    private String levelOne;

    @ApiModelProperty("上级2")
    private String levelTwo;

    @ApiModelProperty("上级3")
    private String levelThree;

    @ApiModelProperty("上级4")
    private String levelFour;

    @ApiModelProperty("上级5")
    private String levelFive;

    @ApiModelProperty("更新区域失败原因")
    private String updateRegionFailureReason;

    @ApiModelProperty("更新业务员失败原因")
    private String updateSalesmanFailureReason;
}

