package com.elitesland.sale.api.vo.resp.taskinfo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-10
 * @desc : 业务员任务管理-任务
 */
@Data
@ApiModel(description = "任务")
public class TaskInfoRespVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = -3593496322969439067L;

    @ApiModelProperty("任务编码")
    private String code;

    @ApiModelProperty("任务名称")
    private String name;

    @ApiModelProperty("任务状态")
    @SysCode(sys = "yst-sale", mod = "SALESMAN_TASK_STATUS")
    private String state;
    private String stateName;

    @ApiModelProperty("是否逾期")
    @SysCode(sys = "yst-sale", mod = "TASK_DELAY_FLAG")
    private String delayFlag;
    private String delayFlagName;

    @ApiModelProperty("任务进度")
    private BigDecimal progress;

    @ApiModelProperty("任务类型")
    @SysCode(sys = "yst-sale", mod = "SALESMAN_TASK_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("所属公司")
    private String ouCode;
    @ApiModelProperty("所属公司名称")
    private String ouName;

    @ApiModelProperty("紧急程度")
    @SysCode(sys = "yst-sale", mod = "TASK_URGENCY_LEVEL")
    private String urgencyLevel;
    private String urgencyLevelName;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("完成时间")
    private LocalDateTime completeTime;

    @ApiModelProperty("重复设置")
    private String repeatSet;
    //private String repeatSetName;

    @ApiModelProperty("重复类型（次/天/周/月）")
    private String repeatType;
    //private String repeatTypeName;

    @ApiModelProperty("重复间隔")
    private BigDecimal repeatInterval;

    @ApiModelProperty("指定天")
    private String appointDay;
    private String appointDayName;

    @ApiModelProperty("重复开始时间")
    private LocalDateTime repeatStartTime;

    @ApiModelProperty("重复结束时间")
    private LocalDateTime repeatEndTime;

    @ApiModelProperty("执行时间")
    private LocalDateTime executTime;

    @ApiModelProperty("活动编码")
    private String promotionCode;

    @ApiModelProperty("活动名称")
    private String promotionName;

    @ApiModelProperty("强制签到")
    @SysCode(sys = "yst-sale", mod = "TASK_FORCE_SIGN_FLAG")
    private String forceSignFlag;
    private String forceSignFlagName;

    @ApiModelProperty("签到范围")
    private BigDecimal signInRange;

    @ApiModelProperty("签退范围")
    private BigDecimal signOutRange;

    @ApiModelProperty("发布人")
    private String publishUser;

    @ApiModelProperty("发布人id")
    private Long publishUserId;

    @ApiModelProperty("发布人code")
    private String publishUserCode;

    @ApiModelProperty("执行模板")
    private String executTemplate;

    @ApiModelProperty("任务描述")
    private String taskDesc;

    @ApiModelProperty("文件信息")
    private String fileInfo;
    @ApiModelProperty("附件编码集合")
    private List<String> fileCodes;

    @ApiModelProperty("执行模板id")
    private Long executTemplateId;

    @ApiModelProperty("执行模板code")
    private String executTemplateCode;

    @ApiModelProperty("执行模板名称")
    private String executTemplateName;

    @ApiModelProperty("任务明细")
    private List<TaskInfoDtlRespVO> dtlRespVOList;

    @ApiModelProperty("文件附件表")
    private List<FileInfoRespVO> fileInfoRespVOS;

    @ApiModelProperty(value = "经销商名称")
    private String dealerName;

    @ApiModelProperty(value = "门店编号")
    private String businessCode;
}
