package com.elitesland.sale.api.vo.resp.crm;

import com.elitesland.sale.api.vo.save.CrmCustAddrSaveVO;
import com.elitesland.sale.api.vo.save.CrmCustQualifySaveVO;
import com.elitesland.sale.api.vo.save.OrgAddrBankAccSaveVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(description = "立马客户表新增编辑入参")
public class LmCrmCustSaveVO implements Serializable {

    private static final long serialVersionUID = 1602512703926463829L;
    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "客户归类")
    private String custType2;

    @ApiModelProperty(value = "客户类型")
    private String custType;

    @ApiModelProperty(value = "客户分类")
    private String custGroup;

    @ApiModelProperty(value = "外部系统编码")
    private String outerCode;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户号")
    private String custCode2;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "统一社会信用代码")
    private String certNo;

    @ApiModelProperty(value = "父项客户号")
    private String pid;

    @ApiModelProperty(value = "状态")
    private String custStatus;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "区域")
    private String region;

    @ApiModelProperty(value = "上一任业务员")
    private String agentEmpId2;

    @ApiModelProperty(value = "业务员")
    private String agentEmpId;

    @ApiModelProperty(value = "结算币种")
    private String custCurr;

    @ApiModelProperty(value = "国家")
    private String country;

    @ApiModelProperty(value = "纳税人类型")
    private String taxpayerType;

    @ApiModelProperty(value = "库存客户号")
    private String invCustCode;

    @ApiModelProperty(value = "向立马订货")
    private String orderSignx;

    @ApiModelProperty(value = "自动生成调整单")
    private String adjustSignx;

    @ApiModelProperty(value = "联系人")
    private String contactName;

    @ApiModelProperty(value = "联系电话")
    private String contactPhone;

    @ApiModelProperty(value = "发票类型")
    private String invType;

    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    @ApiModelProperty(value = "税号")
    private String taxerNo;

    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    @ApiModelProperty(value = "开票电话")
    private String invTel;

    @ApiModelProperty(value = "开户银行")
    private String invPicName;

    @ApiModelProperty(value = "银行账户")
    private String invBankAcc;

    @ApiModelProperty(value = "开票联系人")
    private String invPicPhone;

    @ApiModelProperty(value = "省份")
    private String provinceCode;

//    @ApiModelProperty(value = "归属公司")
//    List<CustBelongOuSaveVO> custBelongOuList;

    @ApiModelProperty(value = "地址簿ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrId;

    @ApiModelProperty(value = "地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty(value = "客户地址列表数据")
    private List<CrmCustAddrSaveVO> addrList;

    @ApiModelProperty(value = "证照信息列表数据")
    private List<CrmCustQualifySaveVO> qualifyList;

    @ApiModelProperty("银行信息保存列表")
    List<OrgAddrBankAccSaveVO> orgAddrBankAccList;



    @ApiModelProperty(value = "银行账户")
    private String invBankName;


    @ApiModelProperty(value = "是否开启四方交易")
    private Boolean es2;

    @ApiModelProperty("法人代表")
    private String legalRepre;

    @ApiModelProperty("是否取消客户 0 不是 1是")
    private Boolean cancelCustFlag;


    @ApiModelProperty("业务类型UDC[yst-sale:BUSINESS_TYPE]")
    private String businessTypeCust;

    @ApiModelProperty("是否自动授信客户 0 不是 1是")
    private Boolean autoCreditFlag;

    @ApiModelProperty("城市")
    private String cityCode;

    @ApiModelProperty("区域")
    private String provincialCode;
}
