package com.elitesland.sale.api.vo.resp.shop;

import com.elitescloud.cloudt.common.convert.BooleanToIntegerConverter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Convert;
import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/9/27 10:53
 */
@Data
@ApiModel(description = "商城管理公司出参")
public class BipCompanyManageRespVO implements Serializable {

    private static final long serialVersionUID = -7446516577077327309L;
    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("组织名称")
    private String buName;

    @ApiModelProperty("组织编码")
    private String buCode;

    @ApiModelProperty("显示公司名称")
    private String viewOuName;

    @ApiModelProperty("显示公司状态")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean viewOuStatus;

    @ApiModelProperty("客服来源")
    private String custServiceSource;
    private String source;

    @ApiModelProperty("客服电话")
    private String serviceTel;

}
