package com.elitesland.sale.api.vo.param.taskinfo;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;


/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-10
 * @desc : 任务
 */
@Data
@ApiModel(description = "任务")
public class TaskInfoQueryVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 5957059580176063900L;

    @ApiModelProperty("主键ID")
    private Long id;
    @ApiModelProperty("主键ID集合")
    private List<Long> ids;

    @ApiModelProperty("任务编码")
    private String code;
    @ApiModelProperty("任务编码集合")
    private List<String> codeList;
    @ApiModelProperty("任务编码模糊查询")
    private String codeKeyword;

    @ApiModelProperty("任务名称")
    private String name;

    @ApiModelProperty("任务编码/名称模糊查询")
    private String taskKeyword;

    @ApiModelProperty("任务状态")
    private String state;
    @ApiModelProperty("任务状态集合")
    private List<String> stateList;

    @ApiModelProperty("是否逾期")
    private String delayFlag;

    @ApiModelProperty("任务进度")
    private BigDecimal progress;

    @ApiModelProperty("任务类型")
    private String type;
    @ApiModelProperty("任务类型集合")
    private List<String> typeList;

    @ApiModelProperty("所属公司")
    private String ouCode;
    @ApiModelProperty("所属公司集合")
    private List<String> ouCodeList;

    @ApiModelProperty("紧急程度")
    private String urgencyLevel;
    @ApiModelProperty("紧急程度集合")
    private List<String> urgencyLevelList;

    //@ApiModelProperty("开始时间")
   // private LocalDateTime startTime;
    @ApiModelProperty("开始时间起始")
    private LocalDateTime startTimeS;
    @ApiModelProperty("开始时间截至")
    private LocalDateTime startTimeE;

   // @ApiModelProperty("结束时间")
    //private LocalDateTime endTime;
    @ApiModelProperty("结束时间起始")
    private LocalDateTime endTimeS;
    @ApiModelProperty("结束时间截至")
    private LocalDateTime endTimeE;

    //@ApiModelProperty("完成时间")
    //private LocalDateTime completeTime;
    @ApiModelProperty("完成时间起始")
    private LocalDateTime completeTimeS;
    @ApiModelProperty("完成时间截至")
    private LocalDateTime completeTimeE;

    @ApiModelProperty("重复设置")
    private String repeatSet;

    @ApiModelProperty("重复类型（次/天/周/月）")
    private String repeatType;
    @ApiModelProperty("重复类型集合")
    private List<String> repeatTypeList;

    @ApiModelProperty("重复间隔")
    private BigDecimal repeatInterval;

    @ApiModelProperty("指定天")
    private String appointDay;

    //@ApiModelProperty("重复开始时间")
    //private LocalDateTime repeatStartTime;
    @ApiModelProperty("重复开始时间起始")
    private LocalDateTime repeatStartTimeS;
    @ApiModelProperty("重复开始时间截至")
    private LocalDateTime repeatStartTimeE;

    //@ApiModelProperty("重复结束时间")
    //private LocalDateTime repeatEndTime;
    @ApiModelProperty("重复结束时间起始")
    private LocalDateTime repeatEndTimeS;
    @ApiModelProperty("重复结束时间截至")
    private LocalDateTime repeatEndTimeE;

    //@ApiModelProperty("执行时间")
   // private LocalDateTime executTime;
    @ApiModelProperty("执行时间起始")
    private LocalDateTime executTimeS;
    @ApiModelProperty("执行时间截至")
    private LocalDateTime executTimeE;

    @ApiModelProperty("活动编码")
    private String promotionCode;
    @ApiModelProperty("活动编码集合")
    private List<String> promotionCodeList;

    @ApiModelProperty("活动名称")
    private String promotionName;

    @ApiModelProperty("强制签到")
    private String forceSignFlag;

    @ApiModelProperty("签到范围")
    private BigDecimal signInRange;

    @ApiModelProperty("签退范围")
    private BigDecimal signOutRange;

    @ApiModelProperty("发布人")
    private String publishUser;

    @ApiModelProperty("发布人id")
    private Long publishUserId;
    @ApiModelProperty("发布人id集合")
    private List<Long> publishUserIds;

    @ApiModelProperty("发布人code")
    private String publishUserCode;
    @ApiModelProperty("发布人code集合")
    private List<String> publishUserCodes;

    @ApiModelProperty("执行模板")
    private String executTemplate;

    @ApiModelProperty("任务描述")
    private String taskDesc;

    @ApiModelProperty("文件信息")
    private String fileInfo;

    @ApiModelProperty("执行模板id")
    private Long executTemplateId;

    @ApiModelProperty("执行模板code")
    private String executTemplateCode;
    @ApiModelProperty("执行模板code集合")
    private List<String> executTemplateCodeList;

    @ApiModelProperty("执行模板名称")
    private String executTemplateName;

    /******明细查询条件******/
    @ApiModelProperty("业务编码/名称模糊查询")
    private String businessKeyword;

    @ApiModelProperty("执行人code集合")
    private List<String> executUserCodes;

    @ApiModelProperty("执行记录模糊查询")
    private String executRecordKeyword;
    /******明细查询条件******/
}
