package com.elitesland.sale.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Danny.Wang
 * @title SalesmanInfoDTO
 * @Date2023/3/2 9:47
 */
@Data
@ApiModel("业务员基本信息")
public class SalesmanInfoDTO implements Serializable {

    /**
     *id
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("id")
    private Long id;

    /**
     *业务员编号
     */
    @ApiModelProperty("业务员编号")
    private String salesmanNo;

    /**
     *业务员类型
     */
    @ApiModelProperty("业务员类型")
    private String salesmanType;

    /**
     *业务员类型名称
     */
    @ApiModelProperty("业务员类型名称")
    private String salesmanTypeName;

    /**
     *公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;

    /**
     *公司编码
     */
    @ApiModelProperty("公司编码")
    private String ouCode;

    /**
     *姓名
     */
    @ApiModelProperty("姓名")
    private String fullName;

    /**
     *办公电话、手机号
     */
    @ApiModelProperty("办公电话、手机号")
    private String phone;

    /**
     *组织ID
     */
    @ApiModelProperty("组织ID")
    private Long orgId;

    /**
     *组织名称
     */
    @ApiModelProperty("组织名称")
    private String orgName;

    /**
     * 头像文件编码
     */
    @ApiModelProperty("头像文件编码")
    private String fileCode;

}
