package com.elitesland.sale.api.vo.param.pro;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 请求参数 - 项目收款计划新增
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/7 8:16 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "项目收款计划新增请求参数")
public class SalContractRecvSaveParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = -4074976761662033414L;

    @ApiModelProperty(value = "主表ID(合同ID)")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty(value = "应收金额")
    private BigDecimal arAmt;

    @ApiModelProperty(value = "币种")
    private String currCode;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "应收日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate arDate;

    @ApiModelProperty(value = "实际收款日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate realRecvDate;

    @ApiModelProperty(value = "录入人")
    private String inputer;

    @ApiModelProperty(value = "录入日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate inputDate;

    @ApiModelProperty(value = "开票日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate invDate;

    @ApiModelProperty(value = "状态")
    private String recvStatus;

}
