package com.elitesland.sale.api.vo.param.taskinfo;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-6-1
 * @desc : 销售业绩统计-经销商-明细
 */

@Data
@ApiModel(description = "销售业绩统计-经销商-明细")
public class SaleStatisticsDealerDtlQueryVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 490992524379472440L;

    @ApiModelProperty("主键ID")
    private Long id;
    @ApiModelProperty("主键ID")
    private List<Long> ids;

    /**
     * 关联id
     */
    @ApiModelProperty("关联id")
    private Long masId;
    @ApiModelProperty("关联ID")
    private List<Long> masIds;

    /**
     * 层级：  0——默认是客户所属的业务员  1、2、...——依次往上查询上级赋值
     */
    @ApiModelProperty("层级：  0——默认是客户所属的业务员  1、2、...——依次往上查询上级赋值")
    private String level;
    @ApiModelProperty("层级集合")
    private List<String> levels;
    /**
     * 业务员编码
     */
    @ApiModelProperty("业务员编码")
    private String code;
    @ApiModelProperty("业务员编码集合")
    private List<String> codes;
    /**
     * 业务员名称
     */
    @ApiModelProperty("业务员名称")
    private String name;

    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String type;
    @ApiModelProperty("类型集合")
    private List<String> types;

}

