package com.elitesland.sale.api.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.sale.api.vo.save.SaleStatisticsDealerSaveVO;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:销售业绩统计-经销商
 * </p>
 *
 * @Author Darren
 * @Date 2023/06/01
 * @Version 1.0
 * @Content:
 */
public interface StatisticsDealerService {

    /**
     * 经销商销售业绩-批量新增
     *
     * @param saveVOList 入参
     * @return 出参对象
     */
    List<SaleStatisticsDealerRespVO> createBatch(List<SaleStatisticsDealerSaveVO> saveVOList);

    /**
     * 经销商销售业绩分页查询
     *
     * @param pageParam 入参
     * @return 经销商销售业绩信息集合
     */
    PagingVO<SaleStatisticsDealerRespVO> page(@RequestBody SaleStatisticsDealerQueryVO pageParam);
}
