package com.elitesland.sale.api.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitesland.sale.api.vo.param.salesman.*;
import com.elitesland.sale.api.vo.resp.salesman.*;
import com.elitesland.sale.api.vo.save.SalesmanInfoSaveVO;
import com.elitesland.sale.dto.SalesmanLevelInfoDTO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author Danny.Wang
 * @title SalesmanInfoService
 * @Date2023/2/21 16:07
 */
public interface SalesmanInfoService {

    ApiResult<Object> save(SalesmanInfoSaveVO salesmanInfoSaveVO);

    ApiResult<PagingVO<SalesmanInfoRespVO>> query(SalesmanInfoQueryVO salesmanInfoQueryVO);

    ApiResult<SalesmanInfoDetailRespVO> queryDetail(Long id);


    SysEmployeeBasicDTO queryDetailByUserId(Long id);


    ApiResult<PagingVO<SalesmanInfoRespVO>> querySubordinate(SalesmanSubordinateQueryVO salesmanSubordinateQueryVO);

    ApiResult<Object> changeStatus(SalesmanInfoChangeVO salesmanInfoChangeVO);

    ApiResult<PagingVO<SalesmanSuperiorRespVO>> querySuperior(SalesmanSuperiorQueryVO salesmanSuperiorQueryVO);

    ApiResult<Object> salesmanImport(MultipartFile file);

    ApiResult<PagingVO<SalesmanDetailInfoRespVO>> querySalesmanAllInfo(SalesmanInfoQueryVO salesmanInfoQueryVO);

    SalesmanLevelInfoDTO queryLevelInfo(Long id);

    List<SalesmanInfoSimpleRespVO> simpleQuery(SalesmanInfoSimpleQueryVO param);

}
