package com.elitesland.sale.api.vo.param.crm;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * .
 *
 * @author Evin.dong
 * @date 2021-05-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "客户表查询入参")
public class CrmCustQueryParamVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 890948467039211262L;

    @ApiModelProperty(value = "客户ids")
    private List<Long> custIds;

    @ApiModelProperty(value = "客户编码")
    private String custCode;
    private List<String> custCodes;

    @ApiModelProperty(value = "客户状态")
    private String custStatus;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "客户分类")
    private String custType;

    @ApiModelProperty(value = "客户归类")
    private String custType2;

    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    @ApiModelProperty(value = "地址号集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> addrNos;

    @ApiModelProperty(value = "业务员员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty(value = "项目公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "销售组织")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "外部系统用户")
    private String custCode2;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "客户联系人")
    private String contPerson;

    @ApiModelProperty(value = "数据同步状态")
    private String intfStatus;

    @ApiModelProperty(value = "联系人电话")
    private String contPersonMobile;

    @ApiModelProperty(value = "是否是内部用户 true: 是, false: 否")
    private Boolean innerFlag;

    @ApiModelProperty(value = "是否翻译数据 true: 翻译, false: 不翻译")
    private Boolean transFlag;

//    @ApiModelProperty(value = "参保信息")
//    private String insured;

    @ApiModelProperty(value = "大B/小B")
    private String custGroup2;
}
